#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/termios.h>
#include <sys/ttycom.h>
#include <fcntl.h>
#include <errno.h>
#include <math.h>

main( int argc, char *argv[])
{
  //Holds Packet that will be sent
  unsigned char DataToSend[10000];
  //Message 
  unsigned char Message[10000];
  //Checksum is computed on this array
  unsigned char ChecksumArray[10000];

  //Checksum Variables
  unsigned int c3 = 0x0A55A;
  int c,v6,cnt;
  short int c2;

  //Length Function Variable
  int value2 = 0xDABA;
  
  //Slot to place message into
  unsigned char slotnum;
  //Type of message
  char texttype;
  //Length of message
  int messagelength;
  //Header
  static unsigned char header[7] = {0x00, 0x00, 0x00, 0x00,
				    0x00, 0x00, 0x00};

  struct termios PortSettings;
  int i;
  int LEDPort;

  if(argc != 2){
	printf("Usage: t03 slot-number\n");
  	exit(1);
  }

  // Set up serial port

  if ((LEDPort = open("/dev/cuaa1", O_RDWR)) < 0) {
    perror("/dev/cuaa1");
    exit(1);
  }

  tcgetattr(LEDPort, &PortSettings);
  cfmakeraw(&PortSettings);

  //  PortSettings.c_cflag |= CS8;
  cfsetispeed(&PortSettings, B2400);
  cfsetospeed(&PortSettings, B2400);

  PortSettings.c_cc[VMIN] = 1;
  PortSettings.c_cc[VTIME] = 0;

  tcsetattr(LEDPort, TCSAFLUSH, &PortSettings);
 
  tcflush(LEDPort, TCIOFLUSH);

// Get the string to use and slot number

  //printf("Enter String:");
  fgets(Message,sizeof Message,stdin);
  //printf("\n(A) - 8x7 Center Scroll\n");
  //printf("(B) - 5x7 Center Scroll\n");
  //printf("(C) - 5x7 Bottom Scroll\n");
  //printf("(D) - 5x7 Bottom Scroll Up (Sign Will Cutoff If Too Long!)\n");
  //printf("Enter Text Type:");
  //fflush(stdin);
  //scanf("%c",&texttype);
  texttype ='B';
  //fflush(stdin);
  //printf("Enter Slot # (1-99):");
  //scanf("%d", &slotnum);
  slotnum= atoi(argv[1]);
  //printf("\nSlot Number:%d\n",slotnum);
  messagelength = strlen(Message) - 1;  

// Verify string and slot number to user

  //printf("\nMessage is: %s\n", Message);
  //printf("Slot Number is: %d\n", slotnum);
  //printf("Message Size is: %d\n", messagelength);

// Build Packet

//Header  
  DataToSend[0] = 0xff;
  DataToSend[1] = 0x35;
  DataToSend[2] = 0x35;
//First Length Bytes  
  DataToSend[3] = ((messagelength + 0x0A) >> 8);
  //printf("\n%x\n",DataToSend[3]);  
  DataToSend[4] = ((messagelength + 0x0A) % 256);
  //printf("\n%x\n",DataToSend[4]);  

//Function of Length Bytes
  //value2 = 0xDABA;
  //printf("%x\n",value2);
  //for(i=1;i<=messagelength;i++){
  //      if((i % 4) == 0){
  //              value2 = value2 + 32767;
  //              }
  //      else if((i % 2) == 0){
  //              value2 = value2 + 32771;
  //              }
  //      else if((i % 1) == 0){
  //              value2 = value2 - 32768;
  //              }
  //     }
  //printf("%x\n",value2);
  //printf("%x  %x\n",(value2 >> 8),(value2 % 256));
  //DataToSend[5] = (value2 >> 8);
  //DataToSend[6] = (value2 % 256);
//Slot Number
  DataToSend[7] = slotnum;
//Zero
  DataToSend[8] = 0x00;
//Second Length Bytes   
  DataToSend[9] = ((messagelength + 0x04) >> 8);
  DataToSend[10] = ((messagelength + 0x04) % 256);
//Zero
  DataToSend[11] = 0x00;
//Text Style Byte
  switch(texttype){
    case 'A':
    case 'a':
      DataToSend[12] = 0x19;
      break;
    case 'B':
    case 'b':
      DataToSend[12] = 0x17;
      break;
    case 'C':
    case 'c':
      DataToSend[12] = 0x1B;
      break;
    case 'D':
    case 'd':
      DataToSend[12] = 0x10;
      break;
    default:
      printf("\nInvalid text type selected! Exiting...");
      exit(1);
  } 
  DataToSend[12] = 0x2f;
//Start Message Byte
  DataToSend[13] = 0x02;
//Message
  for(i=0;i<messagelength;i++){
    DataToSend[14+i] = Message[i];
  }
//End Message Byte
  DataToSend[14+messagelength] = 0x1f;

//Checksum
    
  //Create the Array for checksum computation
  ChecksumArray[0] = DataToSend[1];
  ChecksumArray[1] = DataToSend[2];
  ChecksumArray[2] = DataToSend[3];
  ChecksumArray[3] = DataToSend[4];
  ChecksumArray[4] = DataToSend[7];
  ChecksumArray[5] = DataToSend[8];
  ChecksumArray[6] = DataToSend[9];
  ChecksumArray[7] = DataToSend[10];
  ChecksumArray[8] = DataToSend[11];
  ChecksumArray[9] = DataToSend[12];
  ChecksumArray[10] = DataToSend[13];
  for(i=0;i<messagelength;i++){
    ChecksumArray[11+i] = DataToSend[14+i];
  }
  ChecksumArray[11+messagelength] = DataToSend[14+messagelength];

  //Run checksum algorithm on checksum array
  cnt=0;
  for(i=0;i<messagelength+12;i++){
    //Insert the first checksum 
    if(i==4){
        //printf("\n%x\n",c3);
        DataToSend[5] = (c3 >> 8);
        DataToSend[6] = (c3 % 256);
    }  
    c=ChecksumArray[i];
    //printf("%x\n",c);
    v6 = (c ^ cnt) % 256;
    //printf("%x %x %x\n",v6,c,cnt);
    c2 = (c2 + v6) % 65536;
    //printf("%x\n",c2);
    c3 = (c3 + c2) % 65536;
    //printf("%x\n",c3);
    cnt = (cnt + 1) % 256;
    //printf("%x\n",cnt);
    c3 = RotateRight(c3,1);
    //printf("%x\n\n",c3);
  }

//print checksum for debug
  //printf("%x\n",c3);
  //printf("High Byte: %x\n",c3 >> 8);
  //printf("Low Byte: %x\n",c3 % 256);

//Place Checksum into packet
  DataToSend[15+messagelength]=(c3 >> 8);
  DataToSend[16+messagelength]=(c3 % 256); 

//Print Data Send Array for Debug
  //printf("CHECKSUM ARRAY:");
  //for(i=0;i<=messagelength+11;i++){
  //  printf("%x ",ChecksumArray[i]);
  //}
  //printf("\n");

//Print Data Send Array for Debug
  //printf("ARRAY:");
  //for(i=0;i<=messagelength+16;i++){
  //  printf("%x ",DataToSend[i]);
  //}
  //printf("\n");

//Send completed packet to sign
  write(LEDPort, header, 7);
  write(LEDPort, DataToSend, messagelength+17);

//Send the ending zeros....

  for (i=0; i<256; i++) {
    DataToSend[0] = 0;
    write(LEDPort, DataToSend, 1);
  }

  close(LEDPort);
}

//Helper Functions Follow

/* Performs a Rotate Right operation on a 16-bit bitfield */
int RotateRight(int Value, int Amount)
{
   int i,
       LOBit;

   for (i = 0; i < Amount; i++){
      LOBit = TestBits(Value, 0);
      Value >>= 1;
      Value |= (LOBit << 15);
   }

   return Value;
}
int TestBits(int Value, int Bit)
{
   int i;
   unsigned Mask = (1 << Bit);

   if (Bit > 15 || Bit < 0)
      return 0;
   if (Value & Mask)
      return 1;
   else
      return 0;
}

