#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/termios.h>
#include <sys/ttycom.h>
#include <fcntl.h>
#include <errno.h>
#include <math.h>

main( int argc, char *argv[])
{
  //Holds Packet that will be sent
  unsigned char DataToSend[10000];
  //Message 
  unsigned char Message[10000];
  //Checksum is computed on this array
  unsigned char ChecksumArray[10000];

  //Checksum Variables
  unsigned int c3 = 0x0A55A;
  int c,v6,cnt;
  short int c2;

  //Length Function Variable
  int value2 = 0xDABA;
  
  //Slot to place message into
  unsigned char slotnum;
  //Type of message
  char texttype;
  //Length of message
  int messagelength;
  //Header
  static unsigned char header[7] = {0x00, 0x00, 0x00, 0x00,
				    0x00, 0x00, 0x00};

  struct termios PortSettings;
  int i;
  int LEDPort;

  if(argc != 2){
	printf("Usage: d05 slot-number\n");
  	exit(1);
  }

  // Set up serial port

  if ((LEDPort = open("/dev/cuaa1", O_RDWR)) < 0) {
    perror("/dev/cuaa1");
    exit(1);
  }

  tcgetattr(LEDPort, &PortSettings);
  cfmakeraw(&PortSettings);

  //  PortSettings.c_cflag |= CS8;
  cfsetispeed(&PortSettings, B2400);
  cfsetospeed(&PortSettings, B2400);

  PortSettings.c_cc[VMIN] = 1;
  PortSettings.c_cc[VTIME] = 0;

  tcsetattr(LEDPort, TCSAFLUSH, &PortSettings);
 
  tcflush(LEDPort, TCIOFLUSH);

// Get the string to use and slot number

// Build Packet

//Header  
  DataToSend[0] = 0xff;
  DataToSend[1] = 0x35;
  DataToSend[2] = 0x35;
//First Length Bytes  
  DataToSend[3] = 0x00;
  DataToSend[4] = 0x09;

//Slot Number
  DataToSend[7] = 0x02;
//Zero
  DataToSend[8] = 0x00;
//Second Length Bytes   
  DataToSend[9] = 0x00;
  DataToSend[10] = 0x03;
//Zero
  DataToSend[11] = 0x00;
//Type Byte
  DataToSend[12] = 0x0c; 
//Start Message Byte
  DataToSend[13] = 0x00;
//Seperator Byte
  DataToSend[14] = 0x0f;
  DataToSend[15] = 0x0f;
  DataToSend[16] = 0xff;

//Checksum
    
  //Create the Array for checksum computation
  ChecksumArray[0] = DataToSend[1];
  ChecksumArray[1] = DataToSend[2];
  ChecksumArray[2] = DataToSend[3];
  ChecksumArray[3] = DataToSend[4];
  ChecksumArray[4] = DataToSend[7];
  ChecksumArray[5] = DataToSend[8];
  ChecksumArray[6] = DataToSend[9];
  ChecksumArray[7] = DataToSend[10];
  ChecksumArray[8] = DataToSend[11];
  ChecksumArray[9] = DataToSend[12];
  ChecksumArray[10] = DataToSend[13];
  ChecksumArray[11] = DataToSend[14];
  ChecksumArray[12] = DataToSend[15];
  ChecksumArray[13] = DataToSend[16];

  //Run checksum algorithm on checksum array
  cnt=0;
  for(i=0;i<14;i++){
    //Insert the first checksum 
    if(i==4){
        //printf("\n%x\n",c3);
        DataToSend[5] = (c3 >> 8);
        DataToSend[6] = (c3 % 256);
    }  
    c=ChecksumArray[i];
    //printf("%x\n",c);
    v6 = (c ^ cnt) % 256;
    //printf("%x %x %x\n",v6,c,cnt);
    c2 = (c2 + v6) % 65536;
    //printf("%x\n",c2);
    c3 = (c3 + c2) % 65536;
    //printf("%x\n",c3);
    cnt = (cnt + 1) % 256;
    //printf("%x\n",cnt);
    c3 = RotateRight(c3,1);
    //printf("%x\n\n",c3);
  }

//Place Checksum into packet
  DataToSend[17]=(c3 >> 8);
  DataToSend[18]=(c3 % 256); 


#ifdef DEBUG
//print checksum for debug
  printf("Total Checksum: %x\n",c3);
  printf("High Byte: %x\n",c3 >> 8);
  printf("Low Byte: %x\n",c3 % 256);

//Print Data Send Array for Debug
  printf("CHECKSUM ARRAY:");
  for(i=0;i<=13;i++){
    printf("%x ",ChecksumArray[i]);
  }
  printf("\n");

//Print Data Send Array for Debug
  printf("ARRAY:");
  for(i=0;i<=18;i++){
    printf("%x ",DataToSend[i]);
  }
  printf("\n");
#endif

//Send completed packet to sign
  write(LEDPort, header, 7);
  write(LEDPort, DataToSend, 18);

//Send the ending zeros....

  for (i=0; i<=100; i++) {
    DataToSend[0] = 0;
    write(LEDPort, DataToSend, 1);
  }

  close(LEDPort);
}

//Helper Functions Follow

/* Performs a Rotate Right operation on a 16-bit bitfield */
int RotateRight(int Value, int Amount)
{
   int i,
       LOBit;

   for (i = 0; i < Amount; i++){
      LOBit = TestBits(Value, 0);
      Value >>= 1;
      Value |= (LOBit << 15);
   }

   return Value;
}
int TestBits(int Value, int Bit)
{
   int i;
   unsigned Mask = (1 << Bit);

   if (Bit > 15 || Bit < 0)
      return 0;
   if (Value & Mask)
      return 1;
   else
      return 0;
}

